/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.settings;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Hyperlink;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.config.RuntimeSettings;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.settings.BaseSettingsScene;
import pro.gravit.launcher.gui.scenes.settings.components.LanguageSelector;
import pro.gravit.launcher.gui.scenes.settings.components.ThemeSelector;
import pro.gravit.launcher.gui.stage.ConsoleStage;
import pro.gravit.launcher.runtime.client.DirBridge;
import pro.gravit.utils.helper.IOHelper;

public class GlobalSettingsScene
extends BaseSettingsScene {
    private static final Logger logger = LoggerFactory.getLogger(GlobalSettingsScene.class);
    private ThemeSelector themeSelector;
    private LanguageSelector languageSelector;

    public GlobalSettingsScene(JavaFXApplication application) {
        super("scenes/settings/globalsettings.fxml", application);
    }

    @Override
    public String getName() {
        return "globalsettings";
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.themeSelector = new ThemeSelector(this.application, this.componentList);
        this.languageSelector = new LanguageSelector(this.application, this.componentList);
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#console")).setOnAction(e -> {
            try {
                if (this.application.gui.consoleStage == null) {
                    this.application.gui.consoleStage = new ConsoleStage(this.application);
                }
                if (this.application.gui.consoleStage.isNullScene()) {
                    this.application.gui.consoleStage.setScene(this.application.gui.consoleScene, true);
                }
                this.application.gui.consoleStage.show();
            }
            catch (Exception ex) {
                this.errorHandle(ex);
            }
        });
        Hyperlink updateDirLink = (Hyperlink)LookupHelper.lookup((Node)this.componentList, "#folder", "#path");
        String directoryUpdates = DirBridge.dirUpdates.toAbsolutePath().toString();
        updateDirLink.setText(directoryUpdates);
        if (updateDirLink.getTooltip() != null) {
            updateDirLink.getTooltip().setText(directoryUpdates);
        }
        updateDirLink.setOnAction(e -> this.application.openURL(directoryUpdates));
        ((ButtonBase)LookupHelper.lookup((Node)this.componentList, "#changeDir")).setOnAction(e -> {
            DirectoryChooser directoryChooser = new DirectoryChooser();
            directoryChooser.setTitle(this.application.getTranslation("runtime.scenes.settings.dirTitle"));
            directoryChooser.setInitialDirectory(DirBridge.dir.toFile());
            File choose = directoryChooser.showDialog((Window)this.application.getMainStage().getStage());
            if (choose == null) {
                return;
            }
            Path newDir = choose.toPath().toAbsolutePath();
            try {
                DirBridge.move(newDir);
            }
            catch (IOException ex) {
                this.errorHandle(ex);
            }
            this.application.runtimeSettings.updatesDirPath = newDir.toString();
            this.application.runtimeSettings.updatesDir = newDir;
            String oldDir = DirBridge.dirUpdates.toString();
            DirBridge.dirUpdates = newDir;
            updateDirLink.setText(this.application.runtimeSettings.updatesDirPath);
        });
        LookupHelper.lookupIfPossible((Node)this.layout, "#deleteDir").ifPresent(a -> a.setOnAction(e -> this.application.messageManager.showApplyDialog(this.application.getTranslation("runtime.scenes.settings.deletedir.header"), this.application.getTranslation("runtime.scenes.settings.deletedir.description"), () -> {
            logger.debug("Delete dir: {}", (Object)DirBridge.dirUpdates);
            try {
                IOHelper.deleteDir(DirBridge.dirUpdates, false);
            }
            catch (IOException ex) {
                logger.error("", ex);
                this.application.messageManager.createNotification(this.application.getTranslation("runtime.scenes.settings.deletedir.fail.header"), this.application.getTranslation("runtime.scenes.settings.deletedir.fail.description"));
            }
        }, () -> {}, true)));
        LookupHelper.lookupIfPossible((Node)this.layout, "#back").ifPresent(a -> a.setOnAction(e -> {
            try {
                this.switchToBackScene();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        RuntimeSettings.GlobalSettings settings = this.application.runtimeSettings.globalSettings;
        this.add("PrismVSync", settings.prismVSync, value -> {
            settings.prismVSync = value;
        }, false);
        this.add("DebugAllClients", settings.debugAllClients, value -> {
            settings.debugAllClients = value;
        }, false);
    }
}

