/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.settings;

import java.text.MessageFormat;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.layout.Pane;
import javafx.util.StringConverter;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI;
import pro.gravit.launcher.core.backend.LauncherBackendAPI;
import pro.gravit.launcher.core.backend.LauncherBackendAPIHolder;
import pro.gravit.launcher.gui.components.ServerButton;
import pro.gravit.launcher.gui.components.UserBlock;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.interfaces.SceneSupportUserBlock;
import pro.gravit.launcher.gui.scenes.settings.BaseSettingsScene;
import pro.gravit.launcher.gui.scenes.settings.components.JavaSelector;

public class SettingsScene
extends BaseSettingsScene
implements SceneSupportUserBlock {
    private static final long MAX_JAVA_MEMORY_X64 = 32768L;
    private static final long MAX_JAVA_MEMORY_X32 = 1536L;
    private Label ramLabel;
    private Slider ramSlider;
    private LauncherBackendAPI.ClientProfileSettings profileSettings;
    private JavaSelector javaSelector;
    private UserBlock userBlock;

    public SettingsScene(JavaFXApplication application) {
        super("scenes/settings/settings.fxml", application);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.userBlock = this.use(this.layout, UserBlock::new);
        this.ramSlider = (Slider)LookupHelper.lookup((Node)this.componentList, "#ramSlider");
        this.ramLabel = (Label)LookupHelper.lookup((Node)this.componentList, "#ramLabel");
        this.ramSlider.setSnapToTicks(true);
        this.ramSlider.setShowTickMarks(true);
        this.ramSlider.setShowTickLabels(true);
        this.ramSlider.setMinorTickCount(1);
        this.ramSlider.setMajorTickUnit(1024.0);
        this.ramSlider.setBlockIncrement(1024.0);
        this.ramSlider.setLabelFormatter((StringConverter)new StringConverter<Double>(this){

            public String toString(Double object) {
                return "%.0fG".formatted(object / 1024.0);
            }

            public Double fromString(String string) {
                return null;
            }
        });
        LookupHelper.lookupIfPossible((Node)this.layout, "#back").ifPresent(a -> a.setOnAction(e -> {
            try {
                this.profileSettings = null;
                this.switchToBackScene();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        ProfileFeatureAPI.ClientProfile profile = this.application.profileService.getCurrentProfile();
        this.profileSettings = LauncherBackendAPIHolder.getApi().makeClientProfileSettings(profile);
        this.javaSelector = new JavaSelector(this.componentList, this.profileSettings, profile);
        this.ramSlider.setValue((double)this.getReservedMemoryMbs());
        this.ramSlider.setMax((double)(this.profileSettings.getMaxMemoryBytes(LauncherBackendAPI.ClientProfileSettings.MemoryClass.TOTAL) >> 20));
        this.ramSlider.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.profileSettings.setReservedMemoryBytes(LauncherBackendAPI.ClientProfileSettings.MemoryClass.TOTAL, (long)newValue.intValue() << 20);
            this.updateRamLabel();
        });
        this.updateRamLabel();
        Pane serverButtonContainer = (Pane)LookupHelper.lookup((Node)this.layout, "#serverButton");
        serverButtonContainer.getChildren().clear();
        ServerButton serverButton = ServerButton.createServerButton(this.application, profile);
        serverButton.addTo(serverButtonContainer);
        serverButton.enableSaveButton(null, (EventHandler<ActionEvent>)((EventHandler)e -> {
            try {
                LauncherBackendAPIHolder.getApi().saveClientProfileSettings(this.profileSettings);
                this.switchToBackScene();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        serverButton.enableResetButton(null, (EventHandler<ActionEvent>)((EventHandler)e -> this.reset()));
        for (LauncherBackendAPI.ClientProfileSettings.Flag flag : this.profileSettings.getAvailableFlags()) {
            this.add(flag.name(), this.profileSettings.hasFlag(flag), value -> {
                if (value.booleanValue()) {
                    this.profileSettings.addFlag(flag);
                } else {
                    this.profileSettings.removeFlag(flag);
                }
            }, false);
        }
        this.userBlock.reset();
    }

    private long getReservedMemoryMbs() {
        return this.profileSettings.getReservedMemoryBytes(LauncherBackendAPI.ClientProfileSettings.MemoryClass.TOTAL) >> 20;
    }

    @Override
    public UserBlock getUserBlock() {
        return this.userBlock;
    }

    @Override
    public String getName() {
        return "settings";
    }

    public void updateRamLabel() {
        this.ramLabel.setText(this.getReservedMemoryMbs() == 0L ? this.application.getTranslation("runtime.scenes.settings.ramAuto") : MessageFormat.format(this.application.getTranslation("runtime.scenes.settings.ram"), this.getReservedMemoryMbs()));
    }
}

