/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.settings.components;

import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Pane;
import javafx.stage.PopupWindow;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI;
import pro.gravit.launcher.core.backend.LauncherBackendAPI;
import pro.gravit.launcher.core.backend.LauncherBackendAPIHolder;
import pro.gravit.launcher.gui.helper.LookupHelper;

public class JavaSelector {
    private static final Logger logger = LoggerFactory.getLogger(JavaSelector.class);
    private final ComboBox<LauncherBackendAPI.Java> comboBox;
    private final LauncherBackendAPI.ClientProfileSettings profileSettings;
    private final ProfileFeatureAPI.ClientProfile profile;

    public JavaSelector(Pane layout, LauncherBackendAPI.ClientProfileSettings profileSettings, ProfileFeatureAPI.ClientProfile profile) {
        this.comboBox = (ComboBox)LookupHelper.lookup((Node)layout, "#javaCombo");
        this.profile = profile;
        this.comboBox.getItems().clear();
        this.profileSettings = profileSettings;
        this.comboBox.setConverter((StringConverter)new JavaVersionConverter(profileSettings));
        this.comboBox.setCellFactory((Callback)new JavaVersionCellFactory((StringConverter<LauncherBackendAPI.Java>)this.comboBox.getConverter()));
        this.reset();
    }

    public void reset() {
        boolean reset = true;
        LauncherBackendAPIHolder.getApi().getAvailableJava().thenAccept(javas -> {
            for (LauncherBackendAPI.Java version : javas) {
                if (!this.profileSettings.isCompatible(version)) continue;
                this.comboBox.getItems().add((Object)version);
            }
            this.comboBox.setValue((Object)this.profileSettings.getSelectedJava());
            if (this.comboBox.getTooltip() != null && this.profileSettings.getSelectedJava() != null) {
                this.comboBox.getTooltip().setText(this.profileSettings.getSelectedJava().getPath().toAbsolutePath().toString());
            }
            this.comboBox.setOnAction(e -> {
                LauncherBackendAPI.Java version = (LauncherBackendAPI.Java)this.comboBox.getValue();
                if (version == null) {
                    return;
                }
                logger.info("Select Java {}", (Object)version.getPath().toAbsolutePath().toString());
                this.profileSettings.setSelectedJava(version);
            });
        });
    }

    public String getPath() {
        return ((LauncherBackendAPI.Java)this.comboBox.getValue()).getPath().toAbsolutePath().toString();
    }

    private static class JavaVersionConverter
    extends StringConverter<LauncherBackendAPI.Java> {
        private final LauncherBackendAPI.ClientProfileSettings settings;

        public JavaVersionConverter(LauncherBackendAPI.ClientProfileSettings settings) {
            this.settings = settings;
        }

        public String toString(LauncherBackendAPI.Java object) {
            if (object == null) {
                return "Unknown";
            }
            String postfix = "";
            if (this.settings.isRecommended(object)) {
                postfix = "[RECOMMENDED]";
            }
            return "Java %d %s".formatted(object.getMajorVersion(), postfix);
        }

        public LauncherBackendAPI.Java fromString(String string) {
            return null;
        }
    }

    private static class JavaVersionCellFactory
    implements Callback<ListView<LauncherBackendAPI.Java>, ListCell<LauncherBackendAPI.Java>> {
        private final StringConverter<LauncherBackendAPI.Java> converter;

        public JavaVersionCellFactory(StringConverter<LauncherBackendAPI.Java> converter) {
            this.converter = converter;
        }

        public ListCell<LauncherBackendAPI.Java> call(ListView<LauncherBackendAPI.Java> param) {
            return new JavaVersionListCell(this.converter);
        }
    }

    private static class JavaVersionListCell
    extends ListCell<LauncherBackendAPI.Java> {
        private final StringConverter<LauncherBackendAPI.Java> converter;

        public JavaVersionListCell(StringConverter<LauncherBackendAPI.Java> converter) {
            this.converter = converter;
        }

        protected void updateItem(LauncherBackendAPI.Java item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setText(null);
                this.setTooltip(null);
            } else {
                this.setText(this.converter.toString((Object)item));
                Tooltip tooltip = new Tooltip(item.getPath().toString());
                tooltip.setAnchorLocation(PopupWindow.AnchorLocation.WINDOW_BOTTOM_LEFT);
                this.setTooltip(tooltip);
            }
        }
    }
}

