/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.settings.components;

import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.Pane;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.config.RuntimeSettings;
import pro.gravit.launcher.gui.helper.LookupHelper;

public class LanguageSelector {
    private static final Logger logger = LoggerFactory.getLogger(LanguageSelector.class);
    private final JavaFXApplication application;
    private final ComboBox<RuntimeSettings.LAUNCHER_LOCALE> comboBox;

    public LanguageSelector(JavaFXApplication application, Pane layout) {
        this.application = application;
        this.comboBox = (ComboBox)LookupHelper.lookup((Node)layout, "#languageCombo");
        this.comboBox.getItems().clear();
        this.comboBox.setConverter((StringConverter)new ThemeConverter());
        for (RuntimeSettings.LAUNCHER_LOCALE e2 : RuntimeSettings.LAUNCHER_LOCALE.values()) {
            this.comboBox.getItems().add((Object)e2);
        }
        this.comboBox.getSelectionModel().select((Object)Objects.requireNonNullElse(application.runtimeSettings.locale, RuntimeSettings.LAUNCHER_LOCALE.ENGLISH));
        this.comboBox.setOnAction(e -> {
            RuntimeSettings.LAUNCHER_LOCALE locale = (RuntimeSettings.LAUNCHER_LOCALE)((Object)((Object)this.comboBox.getValue()));
            if (locale == null) {
                return;
            }
            if (locale == application.runtimeSettings.locale) {
                return;
            }
            try {
                application.updateLocaleResources(locale.name);
                application.runtimeSettings.locale = locale;
                application.gui.reload();
            }
            catch (Exception ex) {
                logger.error("", ex);
            }
        });
    }

    private class ThemeConverter
    extends StringConverter<RuntimeSettings.LAUNCHER_LOCALE> {
        private ThemeConverter() {
        }

        public String toString(RuntimeSettings.LAUNCHER_LOCALE object) {
            if (object == null) {
                return "Unknown";
            }
            return LanguageSelector.this.application.getTranslation(String.format("runtime.themes.%s", object.displayName), object.displayName);
        }

        public RuntimeSettings.LAUNCHER_LOCALE fromString(String string) {
            return null;
        }
    }
}

