/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.settings.components;

import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.Pane;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.config.RuntimeSettings;
import pro.gravit.launcher.gui.helper.LookupHelper;

public class ThemeSelector {
    private static final Logger logger = LoggerFactory.getLogger(ThemeSelector.class);
    private final JavaFXApplication application;
    private final ComboBox<RuntimeSettings.LAUNCHER_THEME> comboBox;

    public ThemeSelector(JavaFXApplication application, Pane layout) {
        this.application = application;
        this.comboBox = (ComboBox)LookupHelper.lookup((Node)layout, "#themeCombo");
        this.comboBox.getItems().clear();
        this.comboBox.setConverter((StringConverter)new ThemeConverter());
        for (RuntimeSettings.LAUNCHER_THEME e2 : RuntimeSettings.LAUNCHER_THEME.values()) {
            this.comboBox.getItems().add((Object)e2);
        }
        this.comboBox.getSelectionModel().select((Object)Objects.requireNonNullElse(application.runtimeSettings.theme, RuntimeSettings.LAUNCHER_THEME.COMMON));
        this.comboBox.setOnAction(e -> {
            RuntimeSettings.LAUNCHER_THEME theme = (RuntimeSettings.LAUNCHER_THEME)((Object)((Object)this.comboBox.getValue()));
            if (theme == null || theme == RuntimeSettings.LAUNCHER_THEME.COMMON && application.runtimeSettings.theme == null) {
                return;
            }
            if (theme == application.runtimeSettings.theme) {
                return;
            }
            application.runtimeSettings.theme = theme;
            try {
                application.gui.reload();
            }
            catch (Exception ex) {
                logger.error("", ex);
            }
        });
    }

    private class ThemeConverter
    extends StringConverter<RuntimeSettings.LAUNCHER_THEME> {
        private ThemeConverter() {
        }

        public String toString(RuntimeSettings.LAUNCHER_THEME object) {
            if (object == null) {
                return "Unknown";
            }
            return ThemeSelector.this.application.getTranslation(String.format("runtime.themes.%s", object.displayName), object.displayName);
        }

        public RuntimeSettings.LAUNCHER_THEME fromString(String string) {
            return null;
        }
    }
}

