/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.update;

import java.util.concurrent.CompletionException;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextArea;
import javafx.scene.layout.Pane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.core.backend.LauncherBackendAPI;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.FxScene;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.update.VisualDownloader;

public class UpdateScene
extends FxScene {
    private static final Logger logger = LoggerFactory.getLogger(UpdateScene.class);
    private ProgressBar progressBar;
    private Label speed;
    private Label volume;
    private TextArea logOutput;
    private Button cancel;
    private Label speedtext;
    private Label speederr;
    private Pane speedon;
    private VisualDownloader downloader;

    public UpdateScene(JavaFXApplication application) {
        super("scenes/update/update.fxml", application);
    }

    @Override
    protected void doInit() {
        this.progressBar = (ProgressBar)LookupHelper.lookup((Node)this.layout, "#progress");
        this.speed = (Label)LookupHelper.lookup((Node)this.layout, "#speed");
        this.speederr = (Label)LookupHelper.lookup((Node)this.layout, "#speedErr");
        this.speedon = (Pane)LookupHelper.lookup((Node)this.layout, "#speedOn");
        this.speedtext = (Label)LookupHelper.lookup((Node)this.layout, "#speed-text");
        this.cancel = (Button)LookupHelper.lookup((Node)this.layout, "#cancel");
        this.volume = (Label)LookupHelper.lookup((Node)this.layout, "#volume");
        this.logOutput = (TextArea)LookupHelper.lookup((Node)this.layout, "#outputUpdate");
        this.downloader = new VisualDownloader(this.application, this.progressBar, this.speed, this.volume, log -> this.contextHelper.runInFxThread(() -> this.addLog((String)log)));
        ((ButtonBase)LookupHelper.lookup((Node)this.layout, "#cancel")).setOnAction(e -> {
            this.downloader.cancel();
            try {
                this.switchToBackScene();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
    }

    public LauncherBackendAPI.DownloadCallback makeDownloadCallback() {
        return this.downloader;
    }

    public void addLog(String string) {
        logger.info("Update event {}", (Object)string);
        this.logOutput.appendText(string.concat("\n"));
    }

    @Override
    public void reset() {
        this.progressBar.progressProperty().setValue((Number)0);
        this.logOutput.setText("");
        this.volume.setText("");
        this.speed.setText("0");
        this.progressBar.getStyleClass().removeAll((Object[])new String[]{"progress"});
        this.speederr.setVisible(false);
        this.speedon.setVisible(true);
    }

    @Override
    public void errorHandle(Throwable e) {
        if (e instanceof CompletionException) {
            e = e.getCause();
        }
        this.addLog("Exception %s: %s".formatted(e.getClass(), e.getMessage() == null ? "" : e.getMessage()));
        this.progressBar.getStyleClass().add((Object)"progressError");
        this.speederr.setVisible(true);
        this.speedon.setVisible(false);
        logger.error("", e);
    }

    @Override
    public boolean isDisableReturnBack() {
        return true;
    }

    @Override
    public String getName() {
        return "update";
    }

    public static enum DownloadStatus {
        ERROR,
        HASHING,
        REQUEST,
        DOWNLOAD,
        COMPLETE,
        DELETE;

    }
}

