/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.update;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javafx.beans.property.DoubleProperty;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import pro.gravit.launcher.core.backend.LauncherBackendAPI;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.ContextHelper;

public class VisualDownloader
extends LauncherBackendAPI.DownloadCallback {
    private final JavaFXApplication application;
    private final AtomicLong totalDownloaded = new AtomicLong(0L);
    private final AtomicLong lastUpdateTime = new AtomicLong(0L);
    private final AtomicLong lastDownloaded = new AtomicLong(0L);
    private final AtomicLong totalSize = new AtomicLong();
    private final ProgressBar progressBar;
    private final Label speed;
    private final Label volume;
    private final Consumer<String> addLog;
    private volatile Runnable cancelCallback;

    public VisualDownloader(JavaFXApplication application, ProgressBar progressBar, Label speed, Label volume, Consumer<String> addLog) {
        this.application = application;
        this.progressBar = progressBar;
        this.speed = speed;
        this.volume = volume;
        this.addLog = addLog;
    }

    @Override
    public void onStage(String stage) {
        super.onStage(stage);
        this.addLog.accept(String.format("Stage %s", stage));
        ContextHelper.runInFxThreadStatic(this::resetProgress);
    }

    @Override
    public void onCanCancel(Runnable cancel) {
        super.onCanCancel(cancel);
        this.cancelCallback = cancel;
    }

    @Override
    public void onTotalDownload(long total) {
        super.onTotalDownload(total);
        this.totalSize.set(total);
    }

    @Override
    public void onCurrentDownloaded(long current) {
        super.onCurrentDownloaded(current);
        this.updateProgress(this.totalDownloaded.addAndGet(current));
    }

    private void resetProgress() {
        this.totalDownloaded.set(0L);
        this.lastUpdateTime.set(System.currentTimeMillis());
        this.lastDownloaded.set(0L);
        this.progressBar.progressProperty().setValue((Number)0);
    }

    private void updateProgress(long newValue) {
        DoubleProperty property = this.progressBar.progressProperty();
        property.set((double)newValue / (double)this.totalSize.get());
        long lastTime = this.lastUpdateTime.get();
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastTime >= 130L) {
            double bytesSpeed = (double)(newValue - this.lastDownloaded.get()) / (double)(currentTime - lastTime) * 1000.0;
            String speedFormat = "%.1f".formatted(bytesSpeed * 8.0 / 1000000.0);
            ContextHelper.runInFxThreadStatic(() -> {
                this.volume.setText("%.1f/%.1f MB".formatted((double)newValue / 1048576.0, (double)this.totalSize.get() / 1048576.0));
                this.speed.setText(speedFormat);
            });
            this.lastUpdateTime.set(currentTime);
            this.lastDownloaded.set(newValue);
        }
    }

    public void cancel() {
        this.cancelCallback.run();
    }
}

