/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.stage;

import java.io.IOException;
import javafx.event.Event;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Screen;
import javafx.stage.StageStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.FxStage;
import pro.gravit.launcher.gui.dialogs.AbstractDialog;
import pro.gravit.launcher.gui.helper.LookupHelper;

public class DialogStage
extends FxStage {
    private static final Logger logger = LoggerFactory.getLogger(DialogStage.class);

    public DialogStage(JavaFXApplication application, String title, AbstractDialog dialog) throws Exception {
        super(application, application.newStage());
        this.stage.setTitle(title);
        this.stage.initStyle(StageStyle.TRANSPARENT);
        this.stage.setResizable(false);
        this.stage.setOnCloseRequest(Event::consume);
        this.scene.setFill((Paint)Color.TRANSPARENT);
        try {
            Image icon = new Image(JavaFXApplication.getResourceURL("favicon.png").toString());
            this.stage.getIcons().add((Object)icon);
        }
        catch (IOException e) {
            logger.error("", e);
        }
        this.setClipRadius(10.0, 10.0);
        this.setScene(dialog, true);
        this.enableMouseDrag((Node)dialog.getLayout());
        Screen screen = Screen.getPrimary();
        Rectangle2D bounds = screen.getVisualBounds();
        if (bounds.getMaxX() == 0.0 || bounds.getMaxY() == 0.0) {
            bounds = screen.getBounds();
        }
        logger.info("Bounds: X: {} Y: {}", (Object)bounds.getMaxX(), (Object)bounds.getMaxY());
        LookupHelper.Point2D coords = dialog.getOutSceneCoords(bounds);
        this.stage.setX(coords.x);
        this.stage.setY(coords.y);
    }
}

