/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.stage;

import java.io.IOException;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.gui.core.JavaFXApplication;
import pro.gravit.launcher.gui.core.impl.FxStage;
import pro.gravit.launcher.gui.core.impl.UIComponent;

public class PrimaryStage
extends FxStage {
    private static final Logger logger = LoggerFactory.getLogger(PrimaryStage.class);

    public PrimaryStage(JavaFXApplication application, Stage primaryStage, String title) {
        super(application, primaryStage);
        primaryStage.setTitle(title);
        this.stage.initStyle(StageStyle.TRANSPARENT);
        this.stage.setResizable(true);
        this.scene.setFill((Paint)Color.TRANSPARENT);
        try {
            Image icon = new Image(JavaFXApplication.getResourceURL("favicon.png").toString());
            this.stage.getIcons().add((Object)icon);
        }
        catch (IOException e) {
            logger.error("", e);
        }
        this.setClipRadius(10.0, 10.0);
    }

    public void pushBackground(UIComponent component) {
        this.scenePosition.incrementAndGet();
        this.addBefore((Node)this.visualComponent.getLayout(), (Node)component.getLayout());
    }

    public void pullBackground(UIComponent component) {
        this.scenePosition.decrementAndGet();
        this.pull((Node)component.getLayout());
    }

    @Override
    public void close() {
        Platform.exit();
    }
}

