/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime.backend;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import pro.gravit.launcher.client.utils.DirWatcher;
import pro.gravit.launcher.core.hasher.FileNameMatcher;
import pro.gravit.launcher.core.hasher.HashedDir;
import pro.gravit.launcher.runtime.backend.ReadyProfileImpl;

public class BridgeDirWatcher
extends DirWatcher {
    private final ReadyProfileImpl readyProfile;

    public BridgeDirWatcher(Path dir, HashedDir hdir, FileNameMatcher matcher, boolean digest, ReadyProfileImpl readyProfile) throws IOException {
        super(dir, hdir, matcher, digest);
        this.readyProfile = readyProfile;
    }

    @Override
    protected void onForbiddenModification(WatchEvent<?> event, Path path) {
        String error = String.format("[Watcher] Forbidden modification (%s, %d times): '%s'", event.kind(), event.count(), path);
        byte[] outputBytes = error.getBytes(StandardCharsets.UTF_8);
        this.readyProfile.callback.onErrorOutput(outputBytes, 0, outputBytes.length);
        this.readyProfile.terminate();
    }
}

