/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime.backend;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.base.Downloader;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.optional.OptionalView;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalActionFile;
import pro.gravit.launcher.core.api.LauncherAPIHolder;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI;
import pro.gravit.launcher.core.backend.LauncherBackendAPI;
import pro.gravit.launcher.core.hasher.FileNameMatcher;
import pro.gravit.launcher.core.hasher.HashedDir;
import pro.gravit.launcher.core.hasher.HashedEntry;
import pro.gravit.launcher.core.hasher.HashedFile;
import pro.gravit.launcher.runtime.backend.LauncherBackendImpl;
import pro.gravit.launcher.runtime.backend.ProfileSettingsImpl;
import pro.gravit.launcher.runtime.backend.ReadyProfileImpl;
import pro.gravit.launcher.runtime.client.DirBridge;
import pro.gravit.launcher.runtime.utils.AssetIndexHelper;

public class ClientDownloadImpl {
    private static final Logger logger = LoggerFactory.getLogger(ClientDownloadImpl.class);
    private final LauncherBackendImpl backend;

    ClientDownloadImpl(LauncherBackendImpl backend) {
        this.backend = backend;
    }

    CompletableFuture<LauncherBackendAPI.ReadyProfile> downloadProfile(ClientProfile profile, ProfileSettingsImpl settings, LauncherBackendAPI.DownloadCallback callback) {
        AtomicReference clientRef = new AtomicReference();
        AtomicReference assetRef = new AtomicReference();
        AtomicReference javaRef = new AtomicReference();
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)LauncherAPIHolder.profile().changeCurrentProfile(profile).thenCompose(vv -> this.downloadDir(profile.getDir(), profile.getClientUpdateMatcher(), settings.view, callback))).thenCompose(clientDir -> {
            clientRef.set(clientDir);
            return this.downloadAsset(profile.getAssetDir(), profile.getAssetUpdateMatcher(), profile.getAssetIndex(), callback);
        })).thenCompose(assetDir -> {
            assetRef.set(assetDir);
            Path javaPath = settings.getSelectedJava().getPath();
            if (javaPath.startsWith(DirBridge.dirUpdates)) {
                String javaDirName = DirBridge.dirUpdates.relativize(javaPath).getFileName().toString();
                return this.downloadDir(javaDirName, null, callback);
            }
            return CompletableFuture.completedFuture(null);
        })).thenCompose(javaDir -> {
            javaRef.set(javaDir);
            return CompletableFuture.completedFuture(null);
        })).thenApply(v -> new ReadyProfileImpl(this.backend, profile, settings, (DownloadedDir)clientRef.get(), (DownloadedDir)assetRef.get(), (DownloadedDir)javaRef.get()));
    }

    CompletableFuture<DownloadedDir> downloadAsset(String dirName, FileNameMatcher matcher, String assetIndexString, LauncherBackendAPI.DownloadCallback callback) {
        Path targetDir = DirBridge.dirUpdates.resolve(dirName);
        Path assetIndexPath = targetDir.resolve("indexes").resolve(assetIndexString + ".json");
        return ((CompletableFuture)((CompletableFuture)LauncherAPIHolder.profile().fetchUpdateInfo(dirName).thenComposeAsync(response -> {
            callback.onStage("assetVerify");
            return this.verifyAssetIndex(assetIndexString, (ProfileFeatureAPI.UpdateInfo)response, assetIndexPath, targetDir);
        }, (Executor)this.backend.executorService)).thenApply(assetData -> {
            HashedDir dir = assetData.updateInfo.getHashedDir();
            AssetIndexHelper.modifyHashedDir(assetData.index, dir);
            return new VirtualUpdateInfo(dir, assetData.updateInfo.getUrl());
        })).thenCompose(response -> this.downloadDir(targetDir, (ProfileFeatureAPI.UpdateInfo)response, matcher, callback, e -> e));
    }

    private CompletableFuture<AssetData> verifyAssetIndex(String assetIndexString, ProfileFeatureAPI.UpdateInfo response, Path assetIndexPath, Path targetDir) {
        String assetIndexRelPath = String.format("indexes/%s.json", assetIndexString);
        HashedDir.FindRecursiveResult assetIndexHash = response.getHashedDir().findRecursive(assetIndexRelPath);
        HashedEntry hashedEntry = assetIndexHash.entry;
        if (!(hashedEntry instanceof HashedFile)) {
            return CompletableFuture.failedFuture(new FileNotFoundException(String.format("Asset Index %s not found in the server response", assetIndexString)));
        }
        HashedFile assetIndexHashFile = (HashedFile)hashedEntry;
        try {
            if (Files.exists(assetIndexPath, new LinkOption[0]) && assetIndexHashFile.isSame(assetIndexPath, true)) {
                AssetIndexHelper.AssetIndex assetIndex = AssetIndexHelper.parse(assetIndexPath);
                return CompletableFuture.completedFuture(new AssetData(response, assetIndex));
            }
            Downloader downloader = Downloader.newDownloader(this.backend.executorService);
            LinkedList<Downloader.SizedFile> list = new LinkedList<Downloader.SizedFile>();
            list.add(new Downloader.SizedFile(assetIndexRelPath, assetIndexRelPath, assetIndexHashFile.size));
            return downloader.downloadFiles(list, response.getUrl(), targetDir, null, this.backend.executorService, 1).thenComposeAsync(v -> {
                try {
                    AssetIndexHelper.AssetIndex assetIndex = AssetIndexHelper.parse(assetIndexPath);
                    return CompletableFuture.completedFuture(new AssetData(response, assetIndex));
                }
                catch (IOException e) {
                    return CompletableFuture.failedFuture(e);
                }
            }, (Executor)this.backend.executorService);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    CompletableFuture<DownloadedDir> downloadDir(String dirName, FileNameMatcher matcher, LauncherBackendAPI.DownloadCallback callback) {
        Path targetDir = DirBridge.dirUpdates.resolve(dirName);
        return LauncherAPIHolder.profile().fetchUpdateInfo(dirName).thenCompose(response -> this.downloadDir(targetDir, (ProfileFeatureAPI.UpdateInfo)response, matcher, callback, e -> e));
    }

    CompletableFuture<DownloadedDir> downloadDir(String dirName, FileNameMatcher matcher, OptionalView view, LauncherBackendAPI.DownloadCallback callback) {
        Path targetDir = DirBridge.dirUpdates.resolve(dirName);
        return LauncherAPIHolder.profile().fetchUpdateInfo(dirName).thenCompose(response -> {
            HashedDir hashedDir = response.getHashedDir();
            LinkedList<PathRemapperData> remap = this.applyOptionalMods(view, hashedDir);
            return this.downloadDir(targetDir, new VirtualUpdateInfo(hashedDir, response.getUrl()), matcher, callback, this.makePathRemapperFunction(remap));
        });
    }

    CompletableFuture<DownloadedDir> downloadDir(Path targetDir, ProfileFeatureAPI.UpdateInfo updateInfo, FileNameMatcher matcher, LauncherBackendAPI.DownloadCallback callback, Function<String, String> remap) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                callback.onStage("hashing");
                if (!Files.exists(targetDir, new LinkOption[0])) {
                    Files.createDirectories(targetDir, new FileAttribute[0]);
                }
                HashedDir realFiles = new HashedDir(targetDir, matcher, false, true);
                callback.onStage("diff");
                return updateInfo.getHashedDir().diff(realFiles, matcher);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, this.backend.executorService).thenComposeAsync(diff -> this.downloadFiles(targetDir, updateInfo, callback, (HashedDir.Diff)diff, remap), (Executor)this.backend.executorService)).thenApply(v -> new DownloadedDir(updateInfo.getHashedDir(), targetDir));
    }

    private CompletableFuture<HashedDir.Diff> downloadFiles(Path targetDir, ProfileFeatureAPI.UpdateInfo updateInfo, final LauncherBackendAPI.DownloadCallback callback, HashedDir.Diff diff, Function<String, String> remap) {
        Downloader downloader = Downloader.newDownloader(this.backend.executorService);
        try {
            List<Downloader.SizedFile> files = this.collectFilesAndCreateDirectories(targetDir, diff.mismatch, remap);
            long total = 0L;
            for (Downloader.SizedFile e : files) {
                total += e.size;
            }
            callback.onTotalDownload(total);
            callback.onCanCancel(downloader::cancel);
            return downloader.downloadFiles(files, updateInfo.getUrl(), targetDir, new Downloader.DownloadCallback(){

                @Override
                public void apply(long fullDiff) {
                    callback.onCurrentDownloaded(fullDiff);
                }

                @Override
                public void onComplete(Path path) {
                }
            }, this.backend.executorService, 4).thenComposeAsync(v -> {
                callback.onCanCancel(null);
                callback.onStage("deleteExtra");
                try {
                    this.deleteExtraDir(targetDir, diff.extra, diff.extra.flag);
                }
                catch (IOException ex) {
                    return CompletableFuture.failedFuture(ex);
                }
                callback.onStage("done.part");
                return CompletableFuture.completedFuture(diff);
            }, (Executor)this.backend.executorService);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private List<Downloader.SizedFile> collectFilesAndCreateDirectories(Path dir, HashedDir mismatch, Function<String, String> pathRemapper) throws IOException {
        ArrayList<Downloader.SizedFile> files = new ArrayList<Downloader.SizedFile>();
        mismatch.walk(File.separator, (path, name, entry) -> {
            if (entry.getType() == HashedEntry.Type.DIR) {
                Path dirPath = dir.resolve(path);
                try {
                    if (!Files.exists(dirPath, new LinkOption[0])) {
                        Files.createDirectory(dirPath, new FileAttribute[0]);
                        return HashedDir.WalkAction.CONTINUE;
                    }
                    if (Files.isDirectory(dirPath, new LinkOption[0])) return HashedDir.WalkAction.CONTINUE;
                    throw new IOException(String.format("%s is not a directory", path));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            String pathFixed = path.replace(File.separatorChar, '/');
            if (entry instanceof HashedFile) {
                HashedFile hfile = (HashedFile)entry;
                if (hfile.url != null) {
                    files.add(new Downloader.SizedFile(pathFixed, hfile.url, entry.size()));
                    return HashedDir.WalkAction.CONTINUE;
                }
            }
            files.add(new Downloader.SizedFile(pathFixed, (String)pathRemapper.apply(pathFixed), entry.size()));
            return HashedDir.WalkAction.CONTINUE;
        });
        return files;
    }

    private void deleteExtraDir(Path subDir, HashedDir subHDir, boolean deleteDir) throws IOException {
        block4: for (Map.Entry<String, HashedEntry> mapEntry : subHDir.map().entrySet()) {
            String name = mapEntry.getKey();
            Path path = subDir.resolve(name);
            HashedEntry entry = mapEntry.getValue();
            HashedEntry.Type entryType = entry.getType();
            switch (entryType) {
                case FILE: {
                    Files.delete(path);
                    continue block4;
                }
                case DIR: {
                    this.deleteExtraDir(path, (HashedDir)entry, deleteDir || entry.flag);
                    continue block4;
                }
            }
            throw new AssertionError((Object)("Unsupported hashed entry type: " + entryType.name()));
        }
        if (deleteDir) {
            Files.delete(subDir);
        }
    }

    private Function<String, String> makePathRemapperFunction(LinkedList<PathRemapperData> map) {
        return path -> {
            for (PathRemapperData e : map) {
                if (!path.startsWith(e.key)) continue;
                return e.value;
            }
            return path;
        };
    }

    private LinkedList<PathRemapperData> applyOptionalMods(OptionalView view, HashedDir hdir) {
        for (OptionalAction action : view.getDisabledActions()) {
            if (!(action instanceof OptionalActionFile)) continue;
            OptionalActionFile optionalActionFile = (OptionalActionFile)action;
            optionalActionFile.disableInHashedDir(hdir);
        }
        LinkedList<PathRemapperData> pathRemapper = new LinkedList<PathRemapperData>();
        Set<OptionalActionFile> fileActions = view.getActionsByClass(OptionalActionFile.class);
        for (OptionalActionFile file : fileActions) {
            file.injectToHashedDir(hdir);
            file.files.forEach((k, v) -> {
                if (v == null || v.isEmpty()) {
                    return;
                }
                pathRemapper.add(new PathRemapperData((String)v, (String)k));
                logger.info("Remap prepare {} to {}", v, k);
            });
        }
        pathRemapper.sort(Comparator.comparingInt(c -> -c.key.length()));
        return pathRemapper;
    }

    record AssetData(ProfileFeatureAPI.UpdateInfo updateInfo, AssetIndexHelper.AssetIndex index) {
    }

    private record PathRemapperData(String key, String value) {
    }

    record DownloadedDir(HashedDir dir, Path path) {
    }

    record VirtualUpdateInfo(HashedDir dir, String url) implements ProfileFeatureAPI.UpdateInfo
    {
        @Override
        public HashedDir getHashedDir() {
            return this.dir;
        }

        @Override
        public String getUrl() {
            return this.url;
        }
    }
}

