/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime.backend;

import java.io.IOException;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.runtime.client.DirBridge;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class ECKeyHolder {
    private static final Logger logger = LoggerFactory.getLogger(ECKeyHolder.class);
    public ECPublicKey publicKey;
    public ECPrivateKey privateKey;

    public ECPublicKey getClientPublicKey() {
        return this.publicKey;
    }

    public byte[] sign(byte[] bytes) {
        return SecurityHelper.sign(bytes, this.privateKey);
    }

    public void readKeys() throws IOException, InvalidKeySpecException {
        if (this.privateKey != null || this.publicKey != null) {
            return;
        }
        Path dir = DirBridge.dir;
        Path publicKeyFile = dir.resolve("public.key");
        Path privateKeyFile = dir.resolve("private.key");
        if (IOHelper.isFile(publicKeyFile) && IOHelper.isFile(privateKeyFile)) {
            logger.trace("Reading EC keypair");
            this.publicKey = SecurityHelper.toPublicECDSAKey(IOHelper.read(publicKeyFile));
            this.privateKey = SecurityHelper.toPrivateECDSAKey(IOHelper.read(privateKeyFile));
        } else {
            logger.trace("Generating EC keypair");
            KeyPair pair = SecurityHelper.genECDSAKeyPair(new SecureRandom());
            this.publicKey = (ECPublicKey)pair.getPublic();
            this.privateKey = (ECPrivateKey)pair.getPrivate();
            logger.trace("Writing EC keypair list");
            IOHelper.write(publicKeyFile, this.publicKey.getEncoded());
            IOHelper.write(privateKeyFile, this.privateKey.getEncoded());
        }
    }
}

