/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime.backend;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.events.request.AuthRequestEvent;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.ClientProfileBuilder;
import pro.gravit.launcher.base.profiles.PlayerProfile;
import pro.gravit.launcher.client.ClientLauncherEntryPoint;
import pro.gravit.launcher.client.utils.DirWatcher;
import pro.gravit.launcher.client.utils.MinecraftAuthlibBridge;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI;
import pro.gravit.launcher.core.backend.LauncherBackendAPI;
import pro.gravit.launcher.core.hasher.FileNameMatcher;
import pro.gravit.launcher.runtime.backend.BridgeDirWatcher;
import pro.gravit.launcher.runtime.backend.ClientDownloadImpl;
import pro.gravit.launcher.runtime.backend.LauncherBackendImpl;
import pro.gravit.launcher.runtime.backend.ProfileSettingsImpl;
import pro.gravit.launcher.runtime.client.ClientLauncherProcess;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.JavaHelper;

public class ReadyProfileImpl
implements LauncherBackendAPI.ReadyProfile {
    private static final Logger logger = LoggerFactory.getLogger(ReadyProfileImpl.class);
    final LauncherBackendImpl backend;
    ClientProfile profile;
    final ProfileSettingsImpl settings;
    final ClientDownloadImpl.DownloadedDir clientDir;
    final ClientDownloadImpl.DownloadedDir assetDir;
    final ClientDownloadImpl.DownloadedDir javaDir;
    private volatile Thread writeParamsThread;
    private volatile Thread runThread;
    volatile ClientLauncherProcess process;
    volatile Process nativeProcess;
    volatile LauncherBackendAPI.RunCallback callback;
    volatile MinecraftAuthlibBridge bridge;
    private volatile DirWatcher assetWatcher;
    private volatile DirWatcher clientWatcher;
    private volatile DirWatcher javaWatcher;

    public ReadyProfileImpl(LauncherBackendImpl backend, ClientProfile profile, ProfileSettingsImpl settings, ClientDownloadImpl.DownloadedDir clientDir, ClientDownloadImpl.DownloadedDir assetDir, ClientDownloadImpl.DownloadedDir javaDir) {
        this.backend = backend;
        this.profile = profile;
        this.settings = settings;
        this.clientDir = clientDir;
        this.assetDir = assetDir;
        this.javaDir = javaDir;
    }

    @Override
    public ProfileFeatureAPI.ClientProfile getClientProfile() {
        return this.profile;
    }

    @Override
    public LauncherBackendAPI.ClientProfileSettings getSettings() {
        return this.settings;
    }

    @Override
    public void run(LauncherBackendAPI.RunCallback callback) {
        JavaHelper.JavaVersion java;
        if (this.isAlive()) {
            this.terminate();
        }
        this.callback = callback;
        if (this.backend.hasPermission("launcher.debug.skipfilemonitor") && this.settings.hasFlag(LauncherBackendAPI.ClientProfileSettings.Flag.DEBUG_SKIP_FILE_MONITOR)) {
            ClientProfileBuilder builder = new ClientProfileBuilder(this.profile);
            builder.setUpdate(new ArrayList<String>());
            builder.setUpdateVerify(new ArrayList<String>());
            builder.setUpdateExclusions(new ArrayList<String>());
            this.profile = builder.createClientProfile();
        }
        if ((java = this.settings.getSelectedJava()) == null) {
            java = this.settings.getRecommendedJava();
        }
        this.process = new ClientLauncherProcess(this.clientDir.path(), this.assetDir.path(), java, this.clientDir.path().resolve("resourcepacks"), this.profile, new PlayerProfile(this.backend.getSelfUser()), this.settings.view, this.backend.getSelfUser().getAccessToken(), this.clientDir.dir(), this.assetDir.dir(), this.javaDir == null ? null : this.javaDir.dir(), new AuthRequestEvent.OAuthRequestEvent(this.backend.getAuthToken()), this.backend.getAuthMethod().getName());
        this.process.params.ram = (int)(this.settings.getReservedMemoryBytes(LauncherBackendAPI.ClientProfileSettings.MemoryClass.TOTAL) >> 20);
        if (this.process.params.ram > 0) {
            this.process.jvmArgs.add("-Xms" + this.process.params.ram + "M");
            this.process.jvmArgs.add("-Xmx" + this.process.params.ram + "M");
        }
        this.process.params.fullScreen = this.settings.hasFlag(LauncherBackendAPI.ClientProfileSettings.Flag.FULLSCREEN);
        this.process.params.autoEnter = this.settings.hasFlag(LauncherBackendAPI.ClientProfileSettings.Flag.AUTO_ENTER);
        if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
            this.process.params.lwjglGlfwWayland = this.settings.hasFlag(LauncherBackendAPI.ClientProfileSettings.Flag.LINUX_WAYLAND_SUPPORT);
        }
        if (this.process.params.profile.getClassLoaderConfig() == ClientProfile.ClassLoaderConfig.BRIDGE) {
            this.writeParamsThread = new Thread(this::authlibServer);
            this.writeParamsThread.setDaemon(true);
            this.writeParamsThread.start();
        } else {
            this.writeParamsThread = new Thread(this::writeParams);
            this.writeParamsThread.setDaemon(true);
            this.writeParamsThread.start();
        }
        this.runThread = new Thread(this::readThread);
        this.runThread.setDaemon(true);
        this.runThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readThread() {
        Runnable onClose = null;
        try {
            if (this.process.params.profile.getClassLoaderConfig() == ClientProfile.ClassLoaderConfig.BRIDGE) {
                logger.debug("Start watchers for {}", (Object)this.profile.getTitle());
                FileNameMatcher assetMatcher = this.profile.getAssetUpdateMatcher();
                FileNameMatcher clientMatcher = this.profile.getClientUpdateMatcher();
                BridgeDirWatcher assetWatcher = new BridgeDirWatcher(this.assetDir.path(), this.process.params.assetHDir, assetMatcher, true, this);
                BridgeDirWatcher clientWatcher = new BridgeDirWatcher(this.clientDir.path(), this.process.params.clientHDir, clientMatcher, true, this);
                BridgeDirWatcher javaWatcher = this.process.params.javaHDir == null ? null : new BridgeDirWatcher(this.javaDir.path(), this.process.params.javaHDir, null, true, this);
                onClose = () -> {
                    try {
                        assetWatcher.close();
                        clientWatcher.close();
                        if (javaWatcher != null) {
                            javaWatcher.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                };
                CommonHelper.newThread("Asset Directory Watcher", true, assetWatcher).start();
                CommonHelper.newThread("Client Directory Watcher", true, clientWatcher).start();
                if (javaWatcher != null) {
                    CommonHelper.newThread("Java Directory Watcher", true, javaWatcher).start();
                }
                ClientLauncherEntryPoint.verifyHDir(this.assetDir.path(), this.process.params.assetHDir, assetMatcher, false, false);
                ClientLauncherEntryPoint.verifyHDir(this.clientDir.path(), this.process.params.clientHDir, clientMatcher, false, true);
                if (javaWatcher != null) {
                    ClientLauncherEntryPoint.verifyHDir(this.javaDir.path(), this.process.params.javaHDir, null, false, true);
                }
            }
            logger.debug("Start client {}", (Object)this.profile.getTitle());
            this.process.start(true);
            logger.debug("Start watching client IO {}", (Object)this.profile.getTitle());
            this.readIOLoop();
            this.callback.onReadyToExit();
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException) {
                return;
            }
            logger.error("", e);
            this.terminate();
        }
        finally {
            if (onClose != null) {
                onClose.run();
            }
            if (this.bridge != null) {
                this.bridge.close();
            }
        }
    }

    private void readIOLoop() throws IOException, InterruptedException {
        this.nativeProcess = this.process.getProcess();
        this.callback.onCanTerminate(this::terminate);
        InputStream stream = this.nativeProcess.getInputStream();
        byte[] buf = IOHelper.newBuffer();
        try {
            int length = stream.read(buf);
            while (length >= 0) {
                this.callback.onNormalOutput(buf, 0, length);
                length = stream.read(buf);
            }
        }
        catch (EOFException length) {
            // empty catch block
        }
        if (this.nativeProcess.isAlive()) {
            int code = this.nativeProcess.waitFor();
            this.callback.onFinished(code);
        }
    }

    public void terminate() {
        try {
            if (this.assetWatcher == null) {
                this.assetWatcher.close();
            }
            if (this.clientWatcher == null) {
                this.clientWatcher.close();
            }
            if (this.javaWatcher != null) {
                this.javaWatcher.close();
            }
        }
        catch (Throwable e) {
            logger.error("Error when close watchers", e);
        }
        if (this.bridge != null) {
            this.bridge.close();
        }
        if (this.nativeProcess == null) {
            return;
        }
        this.nativeProcess.destroyForcibly();
        this.callback.onReadyToExit();
    }

    public boolean isAlive() {
        return this.nativeProcess != null && this.nativeProcess.isAlive();
    }

    private void writeParams() {
        try {
            this.process.runWriteParams(new InetSocketAddress("127.0.0.1", Launcher.getConfig().clientPort));
            this.callback.onReadyToExit();
        }
        catch (Throwable e) {
            this.terminate();
        }
    }

    private void authlibServer() {
        try {
            this.bridge = this.process.runAuthlibBridgeServer(new InetSocketAddress("127.0.0.1", Launcher.getConfig().clientPort));
        }
        catch (Throwable e) {
            this.terminate();
        }
    }
}

