/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.runtime.backend;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.base.vfs.Vfs;
import pro.gravit.launcher.base.vfs.VfsDirectory;
import pro.gravit.launcher.base.vfs.directory.OverlayVfsDirectory;
import pro.gravit.launcher.core.backend.LauncherBackendAPI;
import pro.gravit.utils.helper.SecurityHelper;

public class ResourceLayerImpl
implements LauncherBackendAPI.ResourceLayer {
    private static final Logger logger = LoggerFactory.getLogger(ResourceLayerImpl.class);
    private final Path vfsPath;

    public ResourceLayerImpl(Path basePath, List<Path> overlayList) {
        if (overlayList == null || overlayList.isEmpty()) {
            this.vfsPath = basePath;
            return;
        }
        ArrayList<VfsDirectory> overlays = new ArrayList<VfsDirectory>();
        for (Path e : overlayList) {
            VfsDirectory dir = (VfsDirectory)Vfs.get().resolve(basePath.resolve(e));
            if (dir == null) continue;
            overlays.add(dir);
        }
        overlays.add((VfsDirectory)Vfs.get().resolve(basePath));
        OverlayVfsDirectory directory = new OverlayVfsDirectory(overlays);
        String randomName = SecurityHelper.randomStringToken();
        this.vfsPath = Path.of(randomName, new String[0]);
        if (logger.isTraceEnabled()) {
            logger.trace("Make overlay {} from {}", (Object)this.vfsPath, (Object)basePath);
            for (VfsDirectory e : overlays) {
                logger.trace("Layer {}", (Object)e.getClass().getSimpleName());
            }
        }
        Vfs.get().put(this.vfsPath, directory);
    }

    @Override
    public URL getURL(Path path) throws IOException {
        return Vfs.get().getURL(this.vfsPath.resolve(path));
    }
}

