/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.start;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.LauncherConfig;
import pro.gravit.launcher.start.RuntimeModuleManager;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.JavaHelper;
import pro.gravit.utils.helper.LogHelper;

public class ClientLauncherWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ClientLauncherWrapper.class);
    public static final String MAGIC_ARG = "-Djdk.attach.allowAttachSelf";
    public static final String WAIT_PROCESS_PROPERTY = "launcher.waitProcess";
    public static final String NO_JAVA_CHECK_PROPERTY = "launcher.noJavaCheck";
    public static boolean noJavaCheck = Boolean.getBoolean("launcher.noJavaCheck");
    public static boolean waitProcess = Boolean.getBoolean("launcher.waitProcess");
    public static int launcherMemoryLimit = 256;
    public static List<String> customJvmOptions = new ArrayList<String>(0);
    public static RuntimeModuleManager modulesManager;

    public static boolean contains(String[] array, String value) {
        for (String s : array) {
            if (!s.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] arguments) throws IOException, InterruptedException {
        LogHelper.printVersion("Launcher");
        LogHelper.printLicense("Launcher");
        JVMHelper.checkStackTrace(ClientLauncherWrapper.class);
        JVMHelper.verifySystemProperties(Launcher.class, true);
        EnvHelper.checkDangerousParams();
        LauncherConfig config = Launcher.getConfig();
        modulesManager = new RuntimeModuleManager();
        LauncherConfig.initModules(modulesManager);
        if (ClientLauncherWrapper.contains(arguments, "--debug")) {
            waitProcess = true;
        }
        ClientLauncherWrapperContext context = new ClientLauncherWrapperContext();
        context.processBuilder = new ProcessBuilder(new String[0]);
        if (waitProcess) {
            context.processBuilder.inheritIO();
        }
        context.javaVersion = null;
        try {
            if (!noJavaCheck) {
                List<JavaHelper.JavaVersion> javaVersions = JavaHelper.findJava();
                for (JavaHelper.JavaVersion version : javaVersions) {
                    logger.debug("Found Java {} b{} in {} javafx {}", version.version, version.build, version.jvmDir.toString(), version.enabledJavaFX ? "supported" : "not supported");
                    if (context.javaVersion == null) {
                        context.javaVersion = version;
                        continue;
                    }
                    if (version.enabledJavaFX && !context.javaVersion.enabledJavaFX) {
                        context.javaVersion = version;
                        continue;
                    }
                    if (version.enabledJavaFX != context.javaVersion.enabledJavaFX) continue;
                    if (context.javaVersion.version < version.version) {
                        context.javaVersion = version;
                        continue;
                    }
                    if (context.javaVersion.version != version.version || context.javaVersion.build >= version.build) continue;
                    context.javaVersion = version;
                }
            }
        }
        catch (Throwable e) {
            logger.error("", e);
        }
        if (context.javaVersion == null) {
            context.javaVersion = JavaHelper.JavaVersion.getCurrentJavaVersion();
        }
        if (context.javaVersion.version < 17) {
            String message = String.format("GravitLauncher v%s required Java 17 or higher", Version.getVersion());
            logger.error("", (Object)message);
            JOptionPane.showMessageDialog(null, message, "GravitLauncher", 0);
            System.exit(0);
        }
        context.executePath = IOHelper.resolveJavaBin(context.javaVersion.jvmDir);
        String pathLauncher = IOHelper.getCodeSource(ClientLauncherWrapper.class).toString();
        context.mainClass = "pro.gravit.launcher.runtime.LauncherEngineWrapper";
        context.memoryLimit = launcherMemoryLimit;
        context.classpath.add(pathLauncher);
        context.jvmModules.add("javafx.base");
        context.jvmModules.add("javafx.graphics");
        context.jvmModules.add("javafx.fxml");
        context.jvmModules.add("javafx.controls");
        context.jvmModules.add("javafx.media");
        context.jvmModules.add("javafx.web");
        context.args.add(MAGIC_ARG);
        context.args.add("-XX:+DisableAttachMechanism");
        context.clientArgs.addAll(Arrays.asList(arguments));
        EnvHelper.addEnv(context.processBuilder);
        modulesManager.callWrapper(context);
        ArrayList<String> args = new ArrayList<String>(16);
        args.add(context.executePath.toAbsolutePath().toString());
        args.addAll(context.args);
        context.jvmProperties.forEach((key, value) -> args.add(String.format("-D%s=%s", key, value)));
        if (context.memoryLimit != 0) {
            args.add(String.format("-Xmx%dM", context.memoryLimit));
        }
        if (customJvmOptions != null) {
            args.addAll(customJvmOptions);
        }
        if (context.useLegacyClasspathProperty) {
            args.add(String.format("-Djava.class.path=%s", String.join((CharSequence)IOHelper.PLATFORM_SEPARATOR, context.classpath)));
        } else {
            args.add("-cp");
            args.add(String.join((CharSequence)IOHelper.PLATFORM_SEPARATOR, context.classpath));
        }
        args.add(context.mainClass);
        args.addAll(context.clientArgs);
        logger.debug("Commandline: " + String.valueOf(args));
        context.processBuilder.command(args);
        Process process = context.processBuilder.start();
        if (!waitProcess) {
            Thread.sleep(3000L);
            if (!process.isAlive()) {
                int errorcode = process.exitValue();
                if (errorcode != 0) {
                    logger.error("Process exit with error code: {}", (Object)errorcode);
                } else {
                    logger.info("Process exit with code 0");
                }
            } else {
                logger.debug("Process started success");
            }
        } else {
            process.waitFor();
        }
    }

    public static class ClientLauncherWrapperContext {
        public JavaHelper.JavaVersion javaVersion;
        public Path executePath;
        public String mainClass;
        public int memoryLimit;
        public boolean useLegacyClasspathProperty;
        public ProcessBuilder processBuilder;
        public List<String> args = new ArrayList<String>(8);
        public Map<String, String> jvmProperties = new HashMap<String, String>();
        public List<String> classpath = new ArrayList<String>();
        public List<String> jvmModules = new ArrayList<String>();
        public List<String> clientArgs = new ArrayList<String>();
        public List<Path> javaFXPaths = new ArrayList<Path>();

        public void addSystemProperty(String name) {
            String property = System.getProperty(name);
            if (property != null) {
                this.jvmProperties.put(name, property);
            }
        }
    }
}

