/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.LogHelper;

public class FormatHelper {
    private static final Logger logger = LoggerFactory.getLogger(FormatHelper.class);

    public static Ansi rawAnsiFormat(LogHelper.Level level, String dateTime, boolean sub) {
        boolean bright = level != LogHelper.Level.DEBUG;
        Ansi.Color levelColor = switch (level) {
            case LogHelper.Level.WARNING -> Ansi.Color.YELLOW;
            case LogHelper.Level.ERROR -> Ansi.Color.RED;
            default -> Ansi.Color.WHITE;
        };
        Ansi ansi = new Ansi();
        ansi.fg(Ansi.Color.WHITE).a(dateTime);
        ansi.fgBright(Ansi.Color.WHITE).a(" [").bold();
        if (bright) {
            ansi.fgBright(levelColor);
        } else {
            ansi.fg(levelColor);
        }
        ansi.a((Object)level).boldOff().fgBright(Ansi.Color.WHITE).a("] ");
        if (bright) {
            ansi.fgBright(levelColor);
        } else {
            ansi.fg(levelColor);
        }
        if (sub) {
            ansi.a(' ').a(Ansi.Attribute.ITALIC);
        }
        return ansi;
    }

    public static String ansiFormatVersion(String product) {
        return new Ansi().bold().fgBright(Ansi.Color.MAGENTA).a("GravitLauncher ").fgBright(Ansi.Color.BLUE).a("(fork sashok724's Launcher) ").fgBright(Ansi.Color.CYAN).a(product).fgBright(Ansi.Color.WHITE).a(" v").fgBright(Ansi.Color.BLUE).a(Version.getVersion().toString()).fgBright(Ansi.Color.WHITE).a(" (build #").fgBright(Ansi.Color.RED).a(Version.getVersion().build).fgBright(Ansi.Color.WHITE).a(')').reset().toString();
    }

    public static String ansiFormatLicense(String product) {
        return new Ansi().bold().fgBright(Ansi.Color.MAGENTA).a("License for ").fgBright(Ansi.Color.CYAN).a(product).fgBright(Ansi.Color.WHITE).a(" GPLv3").fgBright(Ansi.Color.WHITE).a(". SourceCode: ").fgBright(Ansi.Color.YELLOW).a("https://github.com/GravitLauncher/Launcher").reset().toString();
    }

    public static String rawFormat(LogHelper.Level level, String dateTime, boolean sub) {
        return dateTime + " [" + level.name + (sub ? "]  " : "] ");
    }

    public static String formatVersion(String product) {
        return String.format("GravitLauncher (fork sashok724's Launcher) %s v%s", product, Version.getVersion());
    }

    public static String formatLicense(String product) {
        return String.format("License for %s GPLv3. SourceCode: https://github.com/GravitLauncher/Launcher", product);
    }
}

