/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.logging.LogHelperAppender;
import pro.gravit.utils.logging.SimpleLogHelperImpl;
import pro.gravit.utils.logging.Slf4jLogHelperImpl;

@Deprecated
public final class LogHelper {
    public static final String DEBUG_PROPERTY = "launcher.debug";
    public static final String DEV_PROPERTY = "launcher.dev";
    public static final String STACKTRACE_PROPERTY = "launcher.stacktrace";
    public static final String NO_JANSI_PROPERTY = "launcher.noJAnsi";
    public static final String SLF4J_PROPERTY = "launcher.useSlf4j";
    private static final Set<Consumer<Throwable>> EXCEPTIONS_CALLBACKS = Collections.newSetFromMap(new ConcurrentHashMap(2));
    private static final LogHelperAppender impl;

    private LogHelper() {
    }

    public static void addOutput(OutputEnity output) {
        impl.addOutput(output);
    }

    public static void addExcCallback(Consumer<Throwable> output) {
        EXCEPTIONS_CALLBACKS.add(Objects.requireNonNull(output, "output"));
    }

    public static void addOutput(Output output, OutputTypes type) {
        LogHelper.addOutput(new OutputEnity(Objects.requireNonNull(output, "output"), type));
    }

    public static void addOutput(Path file) throws IOException {
        LogHelper.addOutput(IOHelper.newWriter(file, true));
    }

    public static void addOutput(Writer writer) {
        LogHelper.addOutput(new SimpleLogHelperImpl.WriterOutput(writer), OutputTypes.PLAIN);
    }

    public static void debug(String message) {
        LogHelper.log(Level.DEBUG, message, false);
    }

    public static void dev(String message) {
        LogHelper.log(Level.DEV, message, false);
    }

    public static void debug(String format, Object ... args) {
        LogHelper.debug(String.format(format, args));
    }

    public static void dev(String format, Object ... args) {
        LogHelper.dev(String.format(format, args));
    }

    public static void error(Throwable exc) {
        EXCEPTIONS_CALLBACKS.forEach(e -> e.accept(exc));
        LogHelper.error(LogHelper.toString(exc));
    }

    public static void error(String message) {
        LogHelper.log(Level.ERROR, message, false);
    }

    public static void error(String format, Object ... args) {
        LogHelper.error(String.format(format, args));
    }

    public static void info(String message) {
        LogHelper.log(Level.INFO, message, false);
    }

    public static void info(String format, Object ... args) {
        LogHelper.info(String.format(format, args));
    }

    public static boolean isDebugEnabled() {
        return true;
    }

    public static void setDebugEnabled(boolean debugEnabled) {
        impl.setDebugEnabled(debugEnabled);
    }

    public static boolean isStacktraceEnabled() {
        return true;
    }

    public static void setStacktraceEnabled(boolean stacktraceEnabled) {
        impl.setStacktraceEnabled(stacktraceEnabled);
    }

    public static boolean isDevEnabled() {
        return true;
    }

    public static void setDevEnabled(boolean stacktraceEnabled) {
        impl.setDevEnabled(stacktraceEnabled);
    }

    public static void log(Level level, String message, boolean sub) {
        impl.log(level, message, sub);
    }

    public static void logJAnsi(Level level, Supplier<String> plaintext, Supplier<String> jansitext, boolean sub) {
        impl.logJAnsi(level, plaintext, jansitext, sub);
    }

    public static void printVersion(String product) {
        impl.printVersion(product);
    }

    public static void printLicense(String product) {
        impl.printLicense(product);
    }

    public static boolean removeOutput(OutputEnity output) {
        return impl.removeOutput(output);
    }

    public static void subDebug(String message) {
        LogHelper.log(Level.DEBUG, message, true);
    }

    public static void subDebug(String format, Object ... args) {
        LogHelper.subDebug(String.format(format, args));
    }

    public static void subInfo(String message) {
        LogHelper.log(Level.INFO, message, true);
    }

    public static void subInfo(String format, Object ... args) {
        LogHelper.subInfo(String.format(format, args));
    }

    public static void subWarning(String message) {
        LogHelper.log(Level.WARNING, message, true);
    }

    public static void subWarning(String format, Object ... args) {
        LogHelper.subWarning(String.format(format, args));
    }

    public static String toString(Throwable exc) {
        StringWriter sw = new StringWriter();
        exc.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static void warning(String message) {
        LogHelper.log(Level.WARNING, message, false);
    }

    public static void warning(String format, Object ... args) {
        LogHelper.warning(String.format(format, args));
    }

    static {
        boolean useSlf4j = false;
        try {
            Class.forName("org.slf4j.Logger", false, LogHelper.class.getClassLoader());
            useSlf4j = Boolean.getBoolean(SLF4J_PROPERTY);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        impl = useSlf4j ? new Slf4jLogHelperImpl() : new SimpleLogHelperImpl();
    }

    public static class OutputEnity {
        public final Output output;
        public final OutputTypes type;

        public OutputEnity(Output output, OutputTypes type) {
            this.output = output;
            this.type = type;
        }
    }

    @FunctionalInterface
    public static interface Output {
        public void println(String var1);
    }

    public static enum OutputTypes {
        PLAIN,
        JANSI;

    }

    public static enum Level {
        DEV("DEV"),
        DEBUG("DEBUG"),
        INFO("INFO"),
        WARNING("WARN"),
        ERROR("ERROR");

        public final String name;

        private Level(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

