/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.utils.helper.FormatHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.logging.LogHelperAppender;

public class SimpleLogHelperImpl
implements LogHelperAppender {
    private static final Logger logger = LoggerFactory.getLogger(SimpleLogHelperImpl.class);
    private static final AtomicBoolean DEBUG_ENABLED = new AtomicBoolean(Boolean.getBoolean("launcher.debug"));
    private static final AtomicBoolean STACKTRACE_ENABLED = new AtomicBoolean(Boolean.getBoolean("launcher.stacktrace"));
    private static final AtomicBoolean DEV_ENABLED = new AtomicBoolean(Boolean.getBoolean("launcher.dev"));
    public final boolean JANSI;
    private final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm:ss", Locale.US);
    private final Set<LogHelper.OutputEnity> OUTPUTS = Collections.newSetFromMap(new ConcurrentHashMap(2));

    public SimpleLogHelperImpl() {
        boolean jansi;
        try {
            if (Boolean.getBoolean("launcher.noJAnsi")) {
                jansi = false;
            } else {
                Class.forName("org.fusesource.jansi.Ansi");
                AnsiConsole.systemInstall();
                jansi = true;
            }
        }
        catch (ClassNotFoundException ignored) {
            jansi = false;
        }
        this.JANSI = jansi;
        LogHelper.OutputEnity STD_OUTPUT = new LogHelper.OutputEnity(System.out::println, this.JANSI ? LogHelper.OutputTypes.JANSI : LogHelper.OutputTypes.PLAIN);
        this.addOutput(STD_OUTPUT);
        String logFile = System.getProperty("launcher.logFile");
        if (logFile != null) {
            try {
                this.addOutput(IOHelper.toPath(logFile));
            }
            catch (IOException e) {
                LogHelper.error(e);
            }
        }
    }

    public void addOutput(Writer writer) {
        this.addOutput(new WriterOutput(writer), LogHelper.OutputTypes.PLAIN);
    }

    @Override
    public void log(LogHelper.Level level, String message, boolean sub) {
        String dateTime = this.DATE_TIME_FORMATTER.format(LocalDateTime.now());
        String jansiString = null;
        String plainString = null;
        for (LogHelper.OutputEnity output : this.OUTPUTS) {
            if (output.type == LogHelper.OutputTypes.JANSI && this.JANSI) {
                if (jansiString != null) {
                    output.output.println(jansiString);
                    continue;
                }
                jansiString = this.ansiFormatLog(level, dateTime, message, sub);
                output.output.println(jansiString);
                continue;
            }
            if (plainString != null) {
                output.output.println(plainString);
                continue;
            }
            plainString = this.formatLog(level, message, dateTime, sub);
            output.output.println(plainString);
        }
    }

    @Override
    public void logJAnsi(LogHelper.Level level, Supplier<String> plaintext, Supplier<String> jansitext, boolean sub) {
        if (this.JANSI) {
            this.log(level, jansitext.get(), sub);
        } else {
            this.log(level, plaintext.get(), sub);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return DEBUG_ENABLED.get();
    }

    @Override
    public void setDebugEnabled(boolean debugEnabled) {
        DEBUG_ENABLED.set(debugEnabled);
    }

    @Override
    public boolean isStacktraceEnabled() {
        return STACKTRACE_ENABLED.get();
    }

    @Override
    public void setStacktraceEnabled(boolean stacktraceEnabled) {
        STACKTRACE_ENABLED.set(stacktraceEnabled);
    }

    @Override
    public boolean isDevEnabled() {
        return DEV_ENABLED.get();
    }

    @Override
    public void setDevEnabled(boolean stacktraceEnabled) {
        DEV_ENABLED.set(stacktraceEnabled);
    }

    @Override
    public void addOutput(LogHelper.OutputEnity output) {
        this.OUTPUTS.add(output);
    }

    @Override
    public boolean removeOutput(LogHelper.OutputEnity output) {
        return this.OUTPUTS.remove(output);
    }

    public void rawLog(Supplier<String> plainStr, Supplier<String> jansiStr) {
        String jansiString = null;
        String plainString = null;
        for (LogHelper.OutputEnity output : this.OUTPUTS) {
            if (output.type == LogHelper.OutputTypes.JANSI && this.JANSI) {
                if (jansiString != null) {
                    output.output.println(jansiString);
                    continue;
                }
                jansiString = jansiStr.get();
                output.output.println(jansiString);
                continue;
            }
            if (plainString != null) {
                output.output.println(plainString);
                continue;
            }
            plainString = plainStr.get();
            output.output.println(plainString);
        }
    }

    public void addOutput(LogHelper.Output output, LogHelper.OutputTypes type) {
        this.addOutput(new LogHelper.OutputEnity(Objects.requireNonNull(output, "output"), type));
    }

    public void addOutput(Path file) throws IOException {
        if (this.JANSI) {
            this.addOutput(new JAnsiOutput(IOHelper.newOutput(file, true)), LogHelper.OutputTypes.JANSI);
        } else {
            this.addOutput(IOHelper.newWriter(file, true));
        }
    }

    private String ansiFormatLog(LogHelper.Level level, String dateTime, String message, boolean sub) {
        Ansi ansi = FormatHelper.rawAnsiFormat(level, dateTime, sub);
        ansi.a(message);
        return ansi.reset().toString();
    }

    private String formatLog(LogHelper.Level level, String message, String dateTime, boolean sub) {
        return FormatHelper.rawFormat(level, dateTime, sub) + message;
    }

    @Override
    public void printVersion(String product) {
        String jansiString = null;
        String plainString = null;
        for (LogHelper.OutputEnity output : this.OUTPUTS) {
            if (output.type == LogHelper.OutputTypes.JANSI && this.JANSI) {
                if (jansiString != null) {
                    output.output.println(jansiString);
                    continue;
                }
                jansiString = FormatHelper.ansiFormatVersion(product);
                output.output.println(jansiString);
                continue;
            }
            if (plainString != null) {
                output.output.println(plainString);
                continue;
            }
            plainString = FormatHelper.formatVersion(product);
            output.output.println(plainString);
        }
    }

    @Override
    public void printLicense(String product) {
        String jansiString = null;
        String plainString = null;
        for (LogHelper.OutputEnity output : this.OUTPUTS) {
            if (output.type == LogHelper.OutputTypes.JANSI && this.JANSI) {
                if (jansiString != null) {
                    output.output.println(jansiString);
                    continue;
                }
                jansiString = FormatHelper.ansiFormatLicense(product);
                output.output.println(jansiString);
                continue;
            }
            if (plainString != null) {
                output.output.println(plainString);
                continue;
            }
            plainString = FormatHelper.formatLicense(product);
            output.output.println(plainString);
        }
    }

    public static class WriterOutput
    implements LogHelper.Output,
    AutoCloseable {
        private final Writer writer;

        public WriterOutput(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }

        @Override
        public void println(String message) {
            try {
                this.writer.write(message + System.lineSeparator());
                this.writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final class JAnsiOutput
    extends WriterOutput {
        private JAnsiOutput(OutputStream output) {
            super(IOHelper.newWriter(output));
        }
    }
}

